// author: RuanShengQiang 
// date: 2017/6/21
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
#define PI 3.141592653589f

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

vec4 INPUT(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, (vec2)(tc.x, 1.0f - tc.y));
}

vec3 grayscale (vec3 color) {
  return (vec3)(0.2126f*color.z + 0.7152f*color.y + 0.0722f*color.x);
}

float _abs(float a)
{
	if(a<0.0f)
		return -a;
	else
		return a;
}

float rand(vec2 co){
	float temp; 
	return fract(sin(dot(co.xy ,(vec2)(12.9898f,78.233f))) * 43758.5453f,&temp);
}

float myMod(float x ,float y)
{
	return x-y * floor (x/y);
}

__constant float amplitude = 1.0f;
	// default waves = 30.
__constant  float waves = 30.0f;
float compute(vec2 p, float progress, vec2 center) {
	vec2 o = p*sin(progress * amplitude)-center;
	// horizontal vector
	vec2 h = (vec2)(1.f, 0.f);
	// butterfly polar function (don't ask me why this one :))
	float theta = acos(dot(o, h)) * waves;
	return (exp(cos(theta)) - 2.f*cos(4.f*theta) + pow(sin((2.f*theta - PI) / 24.f), 5.f)) / 10.f;
}

__kernel void MAIN(__read_only image2d_t input1, __read_only image2d_t input2, __write_only image2d_t dstImg,__global FilterParam* param)
{
	float progress = param->cur_time / param->total_time;
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[2];
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 p = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f)) /resolution.xy;
	
	// default colorSeparation = 0.3
	float colorSeparation = 0.3f;
	float inv = 1.f - progress;
	vec2 dir = p - (vec2)(.5f);
	float dist = length(dir);
	float disp = compute(p, progress, (vec2)(0.5f, 0.5f)) ;
	vec4 texTo = INPUT(input2, param, p + inv*disp);
	vec4 texFrom = (vec4)(
	INPUT(input1, param, p + progress*disp*(1.0f - colorSeparation)).x,
	INPUT(input1, param, p + progress*disp).y,
	INPUT(input1, param, p + progress*disp*(1.0f + colorSeparation)).z,1.0f);
	vec4 gl_FragColor = texTo*progress + texFrom*inv;
	write_imagef(dstImg, (int2)(w, textH - h -1), gl_FragColor);
}